## Network Traffic Storms and Their Impact

### Causes and Risks

- **Network storms**: Excessive, uncontrolled traffic flooding the network.
    - Can be broadcast, multicast, or unicast storms.
- **Potential causes**:
    - Misconfigured network settings (e.g., spanning-tree errors)
    - Faulty NICs (Network Interface Cards)
    - Protocol stack errors
    - DoS attacks
- **Consequences**:
    - Exhausts link bandwidth and switch resources.
    - Disrupts normal LAN operation and performance.

---

## Storm Control Overview

### Purpose

- Prevents broadcast, multicast, or unicast storms from disrupting LAN traffic on an interface.

### How It Works

- Monitors incoming traffic levels on each switch interface per second.
- Compares the traffic rate to predefined thresholds.

### Storm Control Thresholds

- **Rising threshold**: Level at which traffic is blocked (set as percentage of bandwidth or as a rate).
- **Falling threshold**: Level at which normal forwarding resumes (must be ≤ rising threshold).
- **Actions when thresholds are exceeded**:
    - Block/Filter excess traffic.
    - Optionally, error-disable the port (shutdown action).
    - Optionally, send an SNMP trap (trap action).

### Measurement Methods

- Percentage of interface bandwidth used.
- Absolute rate (in packets or bits per second).

---

## Storm Control Operation Example

- During normal traffic, rates stay below thresholds and forwarding continues.
- If incoming traffic exceeds the rising threshold, the port blocks the traffic.
- If the rate falls below the falling threshold, the port resumes forwarding.

---

## Configuration of Storm Control

### Steps to Configure

1. Enable storm control on the desired interface.
2. Set thresholds for broadcast, multicast, or unicast traffic.
    - Example:
        - `storm-control broadcast level 60 50` (rising at 60%, falling at 50%)
3. Define the action on storm detection:
    - `shutdown` (error-disables the port)
    - `trap` (sends SNMP alert)
    - Default is to filter out excess traffic.

### Example Configuration


```none
Switch(config)# interface FastEthernet 0/1
Switch(config-if)# storm-control broadcast level 60 50
Switch(config-if)# storm-control action shutdown
```

- Port blocks traffic at 60% bandwidth usage; resumes at 50%.

---

## Verification of Storm Control

- **Command:** `show storm-control`
    - Displays storm control settings and current traffic levels per interface.
    - Example Output:
        - Interface
        - Filter State
        - Upper (rising threshold)
        - Lower (falling threshold)
        - Current (current usage)

---

## Key Points

- Storm control is disabled by default on Cisco switches.
- Must be configured per interface as needed.
- Protects network from performance degradation due to excessive broadcast, multicast, or unicast traffic.